using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        // Citanje dužine niza
        int N = int.Parse(Console.ReadLine());

        // Citanje niza A
        string[] inputA = Console.ReadLine().Split();
        int[] A = Array.ConvertAll(inputA, int.Parse);

        // Citanje niza B
        string[] inputB = Console.ReadLine().Split();
        int[] B = Array.ConvertAll(inputB, int.Parse);

        // Prefiksni XOR niz
        int[] prefixXOR = new int[N + 1];
        prefixXOR[0] = 0;

        for (int i = 1; i <= N; i++)
        {
            prefixXOR[i] = prefixXOR[i - 1] ^ A[i - 1];
        }

        // Glavni deo: Pronalazak maksimalne vrednosti
        long maxResult = 0;

        for (int L = 0; L < N; L++)
        {
            int currentAnd = B[L];
            for (int R = L; R < N; R++)
            {
                // XOR vrednost za podniz A[L..R]
                int currentXOR = prefixXOR[R + 1] ^ prefixXOR[L];

                // Ažuriranje AND vrednosti za podniz B[L..R]
                currentAnd &= B[R];

                // Izracunavanje vrednosti podniza
                long value = (long)currentXOR * currentAnd;

                // Maksimalizacija
                if (value > maxResult)
                {
                    maxResult = value;
                }
            }
        }

        // Rezultat
        Console.WriteLine(maxResult);
    }
}